/**
 * FILE: z650Exceptions.h
 *
 *  DESCRIPTION: Setup of IVPR to point to the EXCEPTION_HANDLERS memory area 
 *               defined in the linker command file.
 *               Default setup of the IVORxx registers. 
 *
 */

#ifndef _Z650EXCEPTIONS_H_
#define _Z650EXCEPTIONS_H_

/*----------------------------------------------------------------------------*/
/* Function declarations                                                      */
/*----------------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

/**
 * This function is used to create a default exceptions handler
 */
void __DefaultExceptionHandler__(void);
asm void __IVOR2Handler__(void);
asm void __IVOR4Handler__(void);

/**
 * This function will setup the zen IVPR and IVORxx registers.
 * IVPR will be set to the EXCEPTION_HANDLERS memory area defined in the 
 * linker command file (.lcf of the current build target)  
 * IVORxx will be default to the exception handler function: __DefaultExceptionHandler__.
 *
 * If an Exception is used in the application code, the exception handler routine
 * should be defined like the __DefaultExceptionHandler__ function 
 * (i.e. interrupt function, force active and placed in the ".__exception_handlers"
 * code section). The corresponding IVORxx register should then be set to this address.
 *    
 *
 * warning This function can only be called after the stack has been
 *          initialised (it saves working registers during the call on r1).
 */
void __initExceptionHandlers(void);

#ifdef __cplusplus
}
#endif

#endif

